
COMMENT:  This syntax is for panel A, surgical confinements of Table 14.4, syntax copyright by Robert B Smith,  2011.
COMMENT This selects surgical confinements.
USE ALL.
COMPUTE filter_$=(ConfType < 1).
VARIABLE LABEL filter_$ 'ConfType < 1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .


COMMENT This estimates the best model using backward elimination, controling for site, Panel A Table 14.4..
HILOGLINEAR
  SiteType(0 2) OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .


COMMENT This estimates the best model using backward elimination for the pooled data, Panel A Table 14.4.
HILOGLINEAR
  OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .

COMMENT This model estimates surgical confinements for precertification (0) in the non onsite hospitals (0) in the pre period (0)
Reverse the sign of the coefficient to obtain onsite complications in the onsite hospitals in the post period.
GENLOG
  Comps  BY SiteType OnsiteHosp PrePost
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN Comps Comps*OnsiteHosp Comps*PrePost Comps*SiteType Comps*OnsiteHosp*PrePost .



COMMENT This syntax is for Panel B, obstetrical confinements of Table 14.4.

COMMENT This selects obstetrical confinements.
USE ALL.
COMPUTE filter_$=(ConfType = 1).
VARIABLE LABEL filter_$ 'ConfType = 1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

COMMENT This estimates the best model for obstetrical confinements using backward elimination, controling for site, Panel B Table 14.4.
HILOGLINEAR
  SiteType(0 2) OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .


COMMENT This estimates the best model for obstetrical confinements using backward elimination for the pooled data, Panel B Table 14.4.
HILOGLINEAR
  OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .

COMMENT This model estimates obstetrical  confinements with zero complications in the non onsite hospitals (0) in the pre period (0)
Reverse the sign of the coefficient to obtain complications in the onsite hospitals in the post period.
GENLOG
  Comps  BY SiteType OnsiteHosp PrePost
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN Comps Comps*OnsiteHosp Comps*PrePost Comps*SiteType Comps*OnsiteHosp*PrePost .


COMMENT This syntax is for Panel C, surgical and or obstetrical complications

COMMENT This selects obstetrical or surgical confinements in Panel  C.
USE ALL.
COMPUTE filter_$=(ConfType = 2).
VARIABLE LABEL filter_$ 'ConfType = 1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

COMMENT This estimates the best model for obstetrical or surgical confinements using backward elimination, controling for site, Panel B Table 14.4.
HILOGLINEAR
  SiteType(0 2) OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .


COMMENT This estimates the best model for obstetrical or surgical confinements using backward elimination for the pooled data, Panel B Table 14.4.
HILOGLINEAR
  OnsiteHosp(0 1) PrePost(0,1) Comps(0 1)  /CWEIGHT=Count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .

COMMENT This model estimates obstetrical or surgical  confinements with zero complications in the non onsite hospitals (0) in the pre period (0)
Reverse the sign of the coefficient to obtain complications in the onsite hospitals in the post period.
GENLOG
  Comps  BY SiteType OnsiteHosp PrePost
  /MODEL = MULTINOMIAL
  /PRINT = FREQ RESID ADJRESID ZRESID DEV ESTIM CORR COV
  /PLOT = RESID( ADJRESID ) NORMPROB( ADJRESID )
  /CRITERIA = CIN(95) ITERATE(20) CONVERGE(.001) DELTA(.5)
  /DESIGN Comps Comps*OnsiteHosp Comps*PrePost Comps*SiteType Comps*OnsiteHosp*PrePost .